import { IMTopic } from "../../../modules/Topic/interfaces/topic.interface";
import { baseSchemaDefinition, baseSchemaOptions } from "./shared/base.model";
import mongoose from "mongoose";

export const MTopic = mongoose.model<IMTopic>(
    'Topic',
    new mongoose.Schema(
        {
            ...baseSchemaDefinition,
            name: {
                type: String,
                required: true,
                unique: true,
            },
            description: {
                type: String,
                required: true,
            },
            level: {
                type: String,
                required: true,
                enum: ['EF I', 'EF II', 'EM', 'ES'],
            },
            discipline_id: {
                type: String,
                required: true,
            }
        },
        baseSchemaOptions
    )
);