import { baseSchemaDefinition, baseSchemaOptions } from './shared/base.model';
import { IMUser } from '../../../modules/user/interfaces/user.interface';
import mongoose from 'mongoose';
import { passwordResetSchema } from './shared/passwordResetSchema';

export const MUser = mongoose.model<IMUser>(
    'User',
    new mongoose.Schema({
        ...baseSchemaDefinition,
            name: {
            type: String,
            required: true,
        },
        email: {
            type: String,
            required: true,
            unique: true, // Assuming emails are unique
            match: [
                /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
                'Please provide a valid email address',
            ],
        },
        password: {
            type: String,
            required: true,
        },
        is_active: {
            type: Boolean,
            required: true,
            default: true, // Default to active user
        },
        email_verified_at: {
            type: Date,
            required: false,
            default: null, // Default to null if not verified
        },
        password_reset: {
            type: passwordResetSchema,
            required: false,
            default: null,
        },
        roles: { // user roles
            type: [ String ],
            required: true,
            default: [],
        }
    },
    baseSchemaOptions
));