import { CreateAuthMiddleware } from "../../../shared/middlewares/auth.middleware";
import { AuthService } from "../../../modules/auth/auth.service";
import { IAuthenticatableEntity } from "../../../modules/auth/interfaces/auth.interface";
import { IRegisterParams } from "../../../modules/auth/interfaces/auth.service.interface";

/**
 * Generic factory for creating authentication middlewares
 * @template T - Type of entity that extends IAuthenticatableEntity
 * @template R - Type of registration parameters that extends IRegisterParams
 */
export class AuthMiddlewareFactory {
    /**
     * Creates a generic authentication middleware
     * @template T - Type of entity that extends IAuthenticatableEntity
     * @template R - Type of registration parameters that extends IRegisterParams
     * @param authService - Generic authentication service
     * @returns Authentication middleware
     */
    public static create<
        T extends IAuthenticatableEntity,
        R extends IRegisterParams
    >(
        authService: AuthService<T, R>
    ) {
        return CreateAuthMiddleware(authService);
    }
}