import { CategoryController } from "../../../modules/Category/category.controller";
import { categorySchemas } from "../../schemas/category.schema";
import { ICategoryService } from "../../../modules/Category/interfaces/category.service.interface";

/**
 * Factory class to create CategoryController instances.
 */
export class CategoryControllerFactory {
    /**
     * Create and return a new CategoryController instance
     * @returns CategoryController instance
     */
    public static create(
        service: ICategoryService
    ): CategoryController {
        return new CategoryController(
            service,
            categorySchemas
        );
    }
}