import { CategoryRouter } from "../../routes/category.router";
import { CategoryController } from "../../../modules/Category/category.controller";
import { RequestHandler } from "express";

/**
 * Factory class to create CategoryRouter instances.
 */
export class CategoryRouterFactory {
    /**
     * Create and return a new CategoryRouter instance
     * @returns CategoryRouter instance
     */
    static create(
        controller: CategoryController,
        authMiddleware: RequestHandler,
        permissionsMiddleware: RequestHandler,
    ): CategoryRouter {
        return new CategoryRouter(
            controller,
            authMiddleware,
            permissionsMiddleware,
        );
    }
}