import { CategoryService } from "../../../modules/Category/category.service";
import { ICategoryRepository } from "../../../modules/Category/interfaces/category.repository.interface";

/**
 * Factory class to create CategoryService instances.
 */
export class CategoryServiceFactory {
    /**
     * Create and return a new CategoryService instance
     * @returns CategoryService instance
     */
    public static create(
        repository: ICategoryRepository
    ): CategoryService {
        return new CategoryService({ repository });
    }
}