import { ClassController } from "../../../modules/Class/class.controller";
import { classSchemas } from "../../schemas/class.schema";
import { IClassService } from "../../../modules/Class/interfaces/class.service.interface";

/**
 * Factory class to create ClassController instances.
 */
export class ClassControllerFactory {
    /**
     * Create and return a new ClassController instance
     * @returns ClassController instance
     */
    public static create(
        service: IClassService
    ): ClassController {
        return new ClassController(service, classSchemas);
    }
}