import { ClassService } from "../../../modules/Class/class.service";
import { IClassRepository } from "../../../modules/Class/interfaces/class.repository.interface";

/**
 * Factory class to create ClassService instances.
 */
export class ClassServiceFactory {
    /**
     * Create and return a new ClassService instance
     * @returns ClassService instance
     */
    static create(repository: IClassRepository): ClassService {
        return new ClassService({ repository });
    }
}