import { DisciplineController } from "../../../modules/Discipline/discipline.controller";
import { disciplineSchemas } from "../../schemas/discipline.schema";
import { IDisciplineService } from "../../../modules/Discipline/interfaces/discipline.service.interface";

/**
 * Factory class to create DisciplineController instances.
 */
export class DisciplineControllerFactory {
    /**
     * Create and return a new DisciplineController instance
     * @returns DisciplineController instance
     */
    public static create(
        service: IDisciplineService
    ): DisciplineController {
        return new DisciplineController(service, disciplineSchemas);
    }
}