import { DisciplineRouter } from "../../routes/discipline.router";
import { DisciplineController } from "../../../modules/Discipline/discipline.controller";
import { RequestHandler } from "express";

/**
 * Factory class to create DisciplineRouter instances.
 */
export class DisciplineRouterFactory {
    /**
     * Create and return a new DisciplineRouter instance
     * @returns DisciplineRouter instance
     */
    static create(
        controller: DisciplineController,
        authMiddleware: RequestHandler,
        permissionsMiddleware: RequestHandler,
    ): DisciplineRouter {
        return new DisciplineRouter(
            controller,
            authMiddleware,
            permissionsMiddleware,
        );
    }
}