import { DisciplineService } from "../../../modules/Discipline/discipline.service";
import { IDisciplineRepository } from "../../../modules/Discipline/interfaces/discipline.repository.interface";

/**
 * Factory class to create DisciplineService instances.
 */
export class DisciplineServiceFactory {
    /**
     * Create and return a new DisciplineService instance
     * @returns DisciplineService instance
     */
    static create(
        repository: IDisciplineRepository
    ): DisciplineService {
        return new DisciplineService({ repository });
    }
}