import { CreatePermissionsMiddleware } from "../../../shared/middlewares/permissions.middleware";
import { IRoleService } from "../../../modules/Roles/interfaces/roles.service.interface";

/**
 * Factory class to create PermissionMiddleware instances.
 */
export class PermissionsMiddlewareFactory {
    /**
     * Create and return a new PermissionMiddleware instance
     * @returns PermissionMiddleware instance
     */
    static create(
        roleService: IRoleService
    ) {
        return CreatePermissionsMiddleware(roleService);
    }
}