import { RoleController } from "../../../modules/Roles/roles.controller";
import { roleSchemas } from "../../schemas/roles.schema";
import { IRoleService } from "../../../modules/Roles/interfaces/roles.service.interface";

/**
 * Factory class to create RoleController instances.
 */
export class RolesControllerFactory {
    /**
     * Create and return a new RoleController instance
     * @returns RoleController instance
     */
    static create(
        service: IRoleService
    ): RoleController {
        return new RoleController(service, roleSchemas);
    }
}