import { RolesRouter } from "../../routes/roles.router";
import { RoleController } from "../../../modules/Roles/roles.controller";
import { RequestHandler } from "express";

/**
 * Factory class to create RolesRouter instances.
 */
export class RolesRouterFactory {
    /**
     * Create and return a new RolesRouter instance
     * @returns RolesRouter instance
     */
    static create(
        controller: RoleController,
        authMiddleware: RequestHandler,
        permissionsMiddleware: RequestHandler,
    ): RolesRouter {
        return new RolesRouter(
            controller,
            authMiddleware,
            permissionsMiddleware,
        );
    }
}