import { RoleService } from "../../../modules/Roles/roles.service";
import { IRoleRepository } from "../../../modules/Roles/interfaces/roles.repository.interface";

/**
 * Factory class to create RoleService instances.
 */
export class RolesServiceFactory {
    /**
     * Create and return a new RoleService instance
     * @returns RoleService instance
     */
    static create(
        repository: IRoleRepository
    ): RoleService {
        return new RoleService({ RoleRepository: repository });
    }
}