import { AuthController } from "../../../../modules/auth/auth.controller";
import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterStudent, IStudentAuthAdapter } from "../../../../modules/Student/interfaces/student.auth.adaptor.interface";
import { allAuthSchemas } from "../../../schemas/auth.schema";

export class StudentAuthControllerFactory {
    public static create(
        authService: AuthService<
            IStudentAuthAdapter,
            IRegisterStudent
        >
    ): AuthController<
        IStudentAuthAdapter,
        IRegisterStudent
    > {
        return new AuthController(
            authService,
            allAuthSchemas.studentAuthSchemas
        );
    }
}