import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterStudent, IStudentAuthAdapter } from "../../../../modules/Student/interfaces/student.auth.adaptor.interface";
import { AuthMiddlewareFactory } from "../../auth/auth.middleware.factory";

/**
 * Specific factory for creating Student authentication middleware
 */
export class StudentAuthMiddlewareFactory {
    /**
     * Creates an authentication middleware for Student
     * @param studentRepository - Student repository
     * @returns Student authentication middleware
     */
    public static create(
        authService: AuthService<
            IStudentAuthAdapter,
            IRegisterStudent
        >
    ) {
        return AuthMiddlewareFactory.create(authService);
    }
}