import { AuthRouter } from '../../../routes/auth.router';
import { AuthController } from '../../../../modules/auth/auth.controller';
import { IRegisterStudent, IStudentAuthAdapter } from '../../../../modules/Student/interfaces/student.auth.adaptor.interface';
import { RequestHandler } from 'express';

/**
 * Specific factory for creating AuthRouter for Student
 */
export class StudentAuthRouterFactory {
    /**
     * Creates an AuthRouter configured for Student
     * @param studentRepository - Student repository
     * @returns AuthRouter for Student
     */
    public static create(
        authController: AuthController<
            IStudentAuthAdapter,
            IRegisterStudent
        >,
        authMiddleware: RequestHandler,
    ){        
        return new AuthRouter(authController, authMiddleware);
    }
}