import { StudentController } from "../../../modules/Student/student.controller";
import { studentSchemas } from "../../schemas/student.schema";
import { IStudentService } from "../../../modules/Student/interfaces/student.service.interface";

/**
 * Factory class to create StudentController instances.
 */
export class StudentControllerFactory {
    /**
     * Create and return a new StudentController instance
     * @returns StudentController instance
     */
    public static create(
        service: IStudentService
    ): StudentController {
        return new StudentController(service, studentSchemas);
    }
}