import { StudentRouter } from "../../routes/student.router";
import { StudentController } from "../../../modules/Student/student.controller";
import { RequestHandler } from "express";
import { AuthRouter } from "../../routes/auth.router";
import { IRegisterStudent, IStudentAuthAdapter } from "../../../modules/Student/interfaces/student.auth.adaptor.interface";

/**
 * Factory class to create StudentRouter instances.
 */
export class StudentRouterFactory {
    /**
     * Create and return a new StudentRouter instance
     * @returns StudentRouter instance
     */
    public static create(
        controller: StudentController,
        authRouter: AuthRouter<
            IStudentAuthAdapter,
            IRegisterStudent
        >,
        authMiddleware: RequestHandler,
    ): StudentRouter {
        return new StudentRouter(
            controller,
            authRouter,
            authMiddleware,
        );
    }
}