import { IStudentRepository } from "../../../modules/Student/interfaces/student.repository.interface";
import { StudentService } from "../../../modules/Student/student.service";

/**
 * Factory class to create StudentService instances.
 */
export class StudentServiceFactory {
    /**
     * Create and return a new StudentService instance
     * @returns StudentService instance
     */
    public static create(
        repository: IStudentRepository
    ): StudentService {
        return new StudentService({ repository });
    }
}