import { AuthController } from "../../../../modules/auth/auth.controller";
import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterTeacher, ITeacherAuthAdapter } from "../../../../modules/Teacher/interfaces/teacher.auth.adaptor.interface";
import { allAuthSchemas } from "../../../schemas/auth.schema";

export class TeacherAuthControllerFactory {
    public static create(
        service: AuthService<
            ITeacherAuthAdapter,
            IRegisterTeacher
        >,
    ): AuthController<
        ITeacherAuthAdapter,
        IRegisterTeacher
    > {
        return new AuthController(
            service,
            allAuthSchemas.teacherAuthSchemas,
        );
    }
}