import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterTeacher, ITeacherAuthAdapter } from "../../../../modules/Teacher/interfaces/teacher.auth.adaptor.interface";
import { AuthMiddlewareFactory } from "../../auth/auth.middleware.factory";

/**
 * Factory específica para criar middleware de autenticação para Teacher
 */
export class TeacherAuthMiddlewareFactory {
    /**
     * Cria um middleware de autenticação para Teacher
     * @param teacherRepository - Repositório de professores
     * @returns Middleware de autenticação para Teacher
     */
    public static create(
        authService: AuthService<
            ITeacherAuthAdapter,
            IRegisterTeacher
        >,
    ) {
        return AuthMiddlewareFactory.create(authService);
    }
}
