import { AuthRouter } from '../../../routes/auth.router';
import { AuthController } from '../../../../modules/auth/auth.controller';
import { IRegisterTeacher, ITeacherAuthAdapter } from '../../../../modules/Teacher/interfaces/teacher.auth.adaptor.interface';
import { RequestHandler } from 'express';

/**
 * Factory específica para criar AuthRouter para Teacher
 */
export class TeacherAuthRouterFactory {
    /**
     * Cria um AuthRouter configurado para Teacher
     * @param teacherRepository - Repositório de professores
     * @returns AuthRouter para Teacher
     */
    public static create(
        authController: AuthController<
            ITeacherAuthAdapter,
            IRegisterTeacher
        >,
        authMiddleware: RequestHandler,
    ) {
        return new AuthRouter(authController, authMiddleware);
    }
}