import { TeacherController } from "../../../modules/Teacher/teacher.controller";
import { teacherSchemas } from "../../schemas/teacher.schema";
import { ITeacherService } from "../../../modules/Teacher/interfaces/teacher.service.interface";

/**
 * Factory class to create TeacherController instances.
 */
export class TeacherControllerFactory {
    /**
     * Create and return a new TeacherController instance
     * @returns TeacherController instance
     */
    static create(
        service: ITeacherService
    ): TeacherController {
        return new TeacherController(service, teacherSchemas);
    }
}