import { TeacherRouter } from "../../routes/teacher.router";
import { TeacherController } from "../../../modules/Teacher/teacher.controller";
import { AuthRouter } from "../../routes/auth.router";
import { IRegisterTeacher, ITeacherAuthAdapter } from "../../../modules/Teacher/interfaces/teacher.auth.adaptor.interface";
import { RequestHandler } from "express";

/**
 * Factory class to create TeacherRouter instances.
 */
export class TeacherRouterFactory {
    /**
     * Create and return a new TeacherRouter instance
     * @returns TeacherRouter instance
     */
    static create(
        controller: TeacherController,
        authRouter: AuthRouter<
            ITeacherAuthAdapter,
            IRegisterTeacher
        >,
        authMiddleware: RequestHandler,
    ): TeacherRouter {
        return new TeacherRouter(
            controller,
            authRouter,
            authMiddleware,
        );
    }
}