import { ITeacherRepository } from "../../../modules/Teacher/interfaces/teacher.repository.interface";
import { TeacherService } from "../../../modules/Teacher/teacher.service";

/**
 * Factory class to create TeacherService instances.
 */
export class TeacherServiceFactory {
    /**
     * Create and return a new TeacherService instance
     * @returns TeacherService instance
     */
    static create(repository: ITeacherRepository): TeacherService {
        return new TeacherService({ repository });
    }
}