import { TopicController } from "../../../modules/Topic/topic.controller";
import { topicSchemas } from "../../schemas/topic.schema";
import { ITopicService } from "../../../modules/Topic/interfaces/topic.service.interface";

/**
 * Factory class to create TopicController instances.
 */
export class TopicControllerFactory {
    /**
     * Create and return a new TopicController instance
     * @returns TopicController instance
     */
    public static create(
        service: ITopicService
    ): TopicController {
        return new TopicController(service, topicSchemas);
    }
}