import { RequestHandler } from "express";
import { TopicController } from "../../../modules/Topic/topic.controller";
import { TopicRouter } from "../../routes/topic.router";

/**
 * Factory class to create TopicRouter instances.
 */
export class TopicRouterFactory {
    /**
     * Create and return a new TopicRouter instance
     * @returns TopicRouter instance
     */
    static create(
        controller: TopicController,
        authMiddleware: RequestHandler,
        permissionsMiddleware: RequestHandler,
    ): TopicRouter {
        return new TopicRouter(
            controller,
            authMiddleware,
            permissionsMiddleware,
        );
    }
}