import { ITopicRepository } from "../../../modules/Topic/interfaces/topic.repository.interface";
import { TopicService } from "../../../modules/Topic/topic.service";

/**
 * Factory class to create TopicService instances.
 */
export class TopicServiceFactory {
    /**
     * Create and return a new TopicService instance
     * @returns TopicService instance
     */
    static create(
        repository: ITopicRepository
    ): TopicService {
        return new TopicService({ repository });
    }
}