import { AuthController } from "../../../../modules/auth/auth.controller";
import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterParams } from "../../../../modules/auth/interfaces/auth.service.interface";
import { IUserAuthAdapter } from "../../../../modules/user/interfaces/user.auth.adaptor.interface";
import { allAuthSchemas } from "../../../schemas/auth.schema";

export class UserAuthControllerFactory {
    public static create(
        authService: AuthService<
            IUserAuthAdapter,
            IRegisterParams
        >
    ): AuthController<
        IUserAuthAdapter,
        IRegisterParams
    > {
        return new AuthController(
            authService,
            allAuthSchemas.userAuthSchemas
        );
    }
}