import { AuthService } from "../../../../modules/auth/auth.service";
import { IRegisterParams } from "../../../../modules/auth/interfaces/auth.service.interface";
import { IUserAuthAdapter } from "../../../../modules/user/interfaces/user.auth.adaptor.interface";
import { AuthMiddlewareFactory } from "../../auth/auth.middleware.factory";

/**
 * Specific factory for creating User authentication middleware
 */
export class UserAuthMiddlewareFactory {
    /**
     * Creates an authentication middleware for User
     * @param userRepository - User repository
     * @returns User authentication middleware
     */
    public static create(
        authService: AuthService<
            IUserAuthAdapter,
            IRegisterParams
        >
    ) {
        return AuthMiddlewareFactory.create(authService);
    }
}