import { AuthRouter } from '../../../routes/auth.router';
import { AuthController } from '../../../../modules/auth/auth.controller';
import { IUserAuthAdapter } from '../../../../modules/user/interfaces/user.auth.adaptor.interface';
import { IRegisterParams } from '../../../../modules/auth/interfaces/auth.service.interface';
import { RequestHandler } from 'express';

/**
 * Specific factory for creating AuthRouter for User
 */
export class UserAuthRouterFactory {
    /**
     * Creates an AuthRouter configured for User
     * @param userRepository - User repository
     * @returns AuthRouter for User
     */
    public static create(
        authController: AuthController<
            IUserAuthAdapter,
            IRegisterParams
        >,
        authMiddleware: RequestHandler,
    ) {
        return new AuthRouter(authController, authMiddleware);
    }
}