import { UserController } from '../../../modules/user/user.controller';
import { userSchemas } from '../../schemas/user.schema';
import { IUserService } from '../../../modules/user/interfaces/user.service.interface';

/**
 * Factory class to create UserController instances.
 */
export class UserControllerFactory {
    /**
     * Create and return a new UserController instance
     * @returns UserController instance
     */
    static create(
        userService: IUserService
    ): UserController {
        return new UserController(userService, userSchemas);
    }
}