import { RequestHandler } from "express";
import { IRegisterParams } from "../../../modules/auth/interfaces/auth.service.interface";
import { IUserAuthAdapter } from "../../../modules/user/interfaces/user.auth.adaptor.interface";
import { UserController } from "../../../modules/user/user.controller";
import { AuthRouter } from "../../routes/auth.router";
import { UserRouter } from "../../routes/user.router";
import { IRouter } from "../../../shared/contracts/IRouter";

/**
 * Factory class to create UserRouter instances.
 */
export class UserRouterFactory {
    /**
     * Create and return a new UserRouter instance
     * @returns UserRouter instance
     */
    static create(
        controller: UserController,
        authRouter: AuthRouter<IUserAuthAdapter, IRegisterParams>,
        classesRouter: IRouter,
        authMiddleware: RequestHandler,
        permissionsMiddleware: RequestHandler,
    ): UserRouter {
        return new UserRouter(
            controller,
            authRouter,
            classesRouter,
            authMiddleware,
            permissionsMiddleware,
        );
    }
}