import { UserService } from '../../../modules/user/user.service';
import { IUserRepository } from '../../../modules/user/interfaces/user.repository.interface';

/**
 * Factory class to create UserService instances.
 */
export class UserServiceFactory {
    /**
     * Create and return a new UserService instance
     * @returns UserService instance
     */
    static create(
        repo: IUserRepository
    ): UserService {
        return new UserService({
            userRepository: repo
        });
    }
}