import { Router } from "express";
import { IRouter } from "../../shared/contracts/IRouter";
import { ClassController } from "../../modules/Class/class.controller";

/**
 * Router class for class endpoints.
 * Maps HTTP routes to ClassController methods.
 */
export class ClassRouter implements IRouter {
    path = '/app/classes';
    router: Router;
    private controller: ClassController;

    constructor (
        controller: ClassController
    ) {
        this.controller = controller;
        this.router = Router();
        this.initRoutes();
    }

    /**
     * Initializes all routes for the class controller
     * Maps endpoints to controller methods
     */
    initRoutes() {

        /**
         * POST /class - Creates a new class
         */
        this.router.post(
            '/',
            this.controller.createClass
        );

        /**
         * GET /class - Lists all classs
         */
        this.router.get(
            '/',
            this.controller.listClasses
        );

        /** 
         * GET /class/:id - Finds a class by ID
         */
        this.router.get(
            '/:id',
            this.controller.getClassById
        );

        /**
         * PUT /class/:id - Updates a class by ID
         */
        this.router.put(
            '/:id',
            this.controller.updateClass
        );

        /**
         * DELETE /class/:id - Deletes a class by ID
         */
        this.router.delete(
            '/:id',
            this.controller.deleteClass
        );
    }

    /**
     * Get the router with all routes
     * @returns Express Router instance
     */
    public getRoutes(): Router {
        return this.router;
    }
}