import z from "zod";

/**
 * Utility function to validate Brazilian ZIP code (CEP)
 * Checks if the cleaned string (only digits) has exactly 8 characters.
 */
export const zipCodeValidation = z
    .string("ZIP code is required")
    .trim()
    .min(1, { message: "ZIP code cannot be empty." })
    .refine((cep: string): boolean => {
        const cleaned = cep.replace(/\D/g, '');
        return cleaned.length === 8;
    }, {
        message: 'Provide a valid Brazilian ZIP code (8 digits).',
    });