import z from "zod";

const refineDate = (val: string) => !isNaN(new Date(val).getTime()) && new Date(val).toISOString() === val;

const regexISO8601 = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/;

export const dateValidation = {
    isoDateSchema: z
        .string()
        .regex(regexISO8601, "Invalid ISO 8601 date format")
        .refine( refineDate, {
            message: "Invalid date value or format mismatch",
        }),

    dateObjectSchema: z
        .instanceof(Date, { message: "Invalid Date object" }),

    optionalIsoDateSchema: z
        .string()
        .regex(regexISO8601, "Invalid ISO 8601 date format")
        .refine( refineDate, {
            message: "Invalid date value or format mismatch",
        }),

    optionalDateObjectSchema: z
        .instanceof(Date, { message: "Invalid Date object" })
        .optional(),
};