import z from "zod";

export const passwordValidation = z
    .string()
    .min(8, 'Password must be at least 8 characters long.')
    .regex(/[A-Z]/, 'Password must include at least one uppercase letter.')
    .regex(/[a-z]/, 'Password must include at least one lowercase letter.')
    .regex(/\d/, 'Password must include at least one number.')
    .regex(/[\W_]/, 'Password must include at least one special character.');