import z from "zod";

export const telephoneValidation = z
    .string()
    .trim()
    .refine((tel) => {
        const cleaned = tel.replace(/\D/g, '');
        return cleaned.length >= 10 && cleaned.length <= 11;
    }, 'Provide a valid telephone number (10 or 11 digits)');