import { ICategory } from "./interfaces/category.interface";

export class Category {
	name: string;
	description: string;

	constructor (
        category: ICategory
    ) {
        Category.validateRequiredFields(category);

        this.name = category.name;
        this.description = category.description;
	}

    private static validateRequiredFields(
        category: ICategory
    ): void {
        const fields: (keyof ICategory)[] = [
            'name',
            'description',
        ];

        for (const field of fields) {
            if (!category[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}