import { Document } from "mongoose";

/**
 * Category interface representing the structure of a category object
 * to use across the application.
 */
export interface ICategory {
    id?: string;
    name: string;
    description: string;
    created_at?: Date;
    updated_at?: Date;
};

/**
 * Category interface for MongoDB specific fields
 */
export interface IMCategory extends Document {
    _id: string;
    name: string;
    description: string;
    created_at?: Date;
    updated_at?: Date;
    __v?: number;
}