import { ICategory } from "./category.interface";

export interface ICategoryRepository {
    createCategory (
        categoryData: ICategory
    ): Promise<ICategory>;

    findCategoryById (
        id: string
    ): Promise<ICategory | null>;

    findCategoryByName (
        name: string
    ): Promise<ICategory | null>;

    listCategories (
        filter: Partial<ICategory>
    ): Promise<ICategory[]>;

    updateCategoryById (
        id: string,
        categoryData: Partial<ICategory>
    ): Promise<ICategory | null>;

    deleteCategoryById (
        id: string
    ): Promise<ICategory | null>;
}