import { ICategory } from "./category.interface";
import { ICategoryRepository } from "./category.repository.interface";

export interface IParamsCategoryService {
    repository: ICategoryRepository;
}

export interface IParamsCreateCategory {
    name: string;
    description: string;
}

export interface IParamsUpdateCategory {
    id: string;
    data: Partial<ICategory>;
}

export interface ICategoryService {
    createCategory(
        params: IParamsCreateCategory,
    ): Promise<ICategory>;

    getCategoryById(
        id: string,
    ): Promise<ICategory>;

    listCategories(
        filter: object
    ): Promise<ICategory[]>;

    updateCategoryById(
        params: IParamsUpdateCategory
    ): Promise<ICategory>;

    deleteCategoryById(
        id: string
    ): Promise<ICategory>;
}