import { Document } from "mongoose";

/**
 * Class interface representing the structure of a class object
 * to use across the application.
 */
export interface IClass {
    id?: string;
    name: string;
    main_student_id: string;
    teacher_id: string;
    topic_id: string;
    additional_students?: string[];
    link?: string;
    streaming_id?: string;
    type: 'individual' | 'group';
    start_time: Date;
    end_time: Date;
    status: 'scheduled' | 'canceled' | 'completed';
    payment_status: 'pending' | 'paid' | 'refunded';
    created_at?: Date;
    updated_at?: Date;
};

/**
 * Class interface for MongoDB specific fields
 */
export interface IMClass extends Document {
    _id: string;
    name: string;
    topic_id: string;
    teacher_id: string;
    main_student_id: string;
    additional_students?: string[];
    link?: string;
    streaming_id?: string;
    type: 'individual' | 'group';
    start_time: Date;
    end_time: Date;
    status: 'scheduled' | 'canceled' | 'completed';
    payment_status: 'pending' | 'paid' | 'refunded';
    created_at: Date;
    updated_at: Date;
    __v?: number;
}