import { IClass } from "./class.interface";
import { IClassFilter } from "./class.service.interface";

export interface IClassRepository {
    createClass (
        classData: IClass
    ): Promise<IClass>;

    findClassById (
        id: string
    ): Promise<IClass | null>;

    listClasses (
        filter: IClassFilter
    ): Promise<IClass[]>;

    updateClassById (
        id: string,
        classData: Partial<IClass>
    ): Promise<IClass | null>;

    deleteClassById (
        id: string
    ): Promise<IClass | null>;
}