import { IClassRepository } from "./class.repository.interface"
import { IClass } from "./class.interface";
import { IStudent } from "../../Student/interfaces/student.interface";
import { ITeacher } from "../../Teacher/interfaces/teacher.interface";
import { ITopic } from "../../Topic/interfaces/topic.interface";

export interface IClassDependences {
    repository: IClassRepository;
}

export type IListStudents = (filter: object) => Promise<IStudent[]>;
export type IGetStudentById = (id: string) => Promise<IStudent>;
export type IGetTeacherById = (id: string) => Promise<ITeacher>;
export type IGetTopicById = (id: string) => Promise<ITopic>;

export interface IParamsCreateClass {
    main_student_id: string;
    teacher_id: string;
    topic_id: string;
    additional_students?: string[];
    start_time: Date;
    end_time?: Date;
}

export interface IParamsUpdateClass {
    id: string;
    data: {
        teacher_id?: string;
        topic_id?: string;
        additional_students?: string[];
        start_time?: Date;
        end_time?: Date;
        status?: 'scheduled' | 'canceled' | 'completed';
        payment_status?: 'pending' | 'paid' | 'refunded';
    };
}

export interface IClassFilter {
    topic_id?: string;
    teacher_id?: string;
    student_id?: string;
    start_time?: Date;
    end_time?: Date;
    type?: 'individual' | 'group';
    status?: 'scheduled' | 'canceled' | 'completed';
    payment_status?: 'pending' | 'paid' | 'refunded';
}

export interface IClassService {
    createClass(
        params: IParamsCreateClass,
    ): Promise<IClass>;

    getClassById(
        id: string,
    ): Promise<IClass | null>;

    listClasses(
        filter?: object
    ): Promise<IClass[]>;

    updateClassById(
        params: IParamsUpdateClass
    ): Promise<IClass | null>;

    deleteClassById(
        id: string
    ): Promise<IClass | null>;
}

export interface IClassTeacherService {
    listClasses(
        filter?: object
    ): Promise<IClass[]>;
}