import { IDiscipline } from "./interfaces/discipline.interface";

export class Discipline {
	name: string;
	description: string;
	category_id: string;

	constructor (
        discipline: IDiscipline
    ) {
		Discipline.validateRequiredFields(discipline);

        this.name = discipline.name;
        this.description = discipline.description;
		this.category_id = discipline.category_id;
	}

	private static validateRequiredFields(
        discipline: IDiscipline
    ): void {
        const fields: (keyof IDiscipline)[] = [
            'name',
            'description',
			'category_id',
        ];

        for (const field of fields) {
            if (!discipline[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}