import { Document } from "mongoose";

/**
 * Discipline interface representing the structure of a discipline object
 * to use across the application.
 */
export interface IDiscipline {
    id?: string;
    name: string;
    description: string;
    category_id: string;
    created_at?: Date;
    updated_at?: Date;
};

/**
 * Discipline interface for MongoDB specific fields
 */
export interface IMDiscipline extends Document {
    _id: string;
    name: string;
    description: string;
    category_id: string;
    created_at?: Date;
    updated_at?: Date;
    __v?: number;
}